package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class ColocationConstraintViewer implements ColocationConstraint {
  public final Vertex viewedVertex;

  public ColocationConstraintViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "ColocationConstraint".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof ColocationConstraintViewer ? ((ColocationConstraintViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "ColocationConstraintViewer{" + getViewedVertex().toString() + "}";
  }
}
