package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConstrainedTask extends VertexViewer {
  /**
   * getter for required property "relativeDeadlineNumerator".
   * @return "relativeDeadlineNumerator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getRelativeDeadlineNumerator() {
    return getViewedVertex().getProperties().containsKey("relativeDeadlineNumerator") ?
                    (Long) getViewedVertex().getProperties().get("relativeDeadlineNumerator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "relativeDeadlineNumerator".
   * @param relativeDeadlineNumerator value for required property "relativeDeadlineNumerator".
   */
  default void setRelativeDeadlineNumerator(Long relativeDeadlineNumerator) {
    getViewedVertex().getProperties().put("relativeDeadlineNumerator", VertexProperty.create(relativeDeadlineNumerator));
  }

  /**
   * getter for required property "relativeDeadlineDenominator".
   * @return "relativeDeadlineDenominator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getRelativeDeadlineDenominator() {
    return getViewedVertex().getProperties().containsKey("relativeDeadlineDenominator") ?
                    (Long) getViewedVertex().getProperties().get("relativeDeadlineDenominator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "relativeDeadlineDenominator".
   * @param relativeDeadlineDenominator value for required property "relativeDeadlineDenominator".
   */
  default void setRelativeDeadlineDenominator(Long relativeDeadlineDenominator) {
    getViewedVertex().getProperties().put("relativeDeadlineDenominator", VertexProperty.create(relativeDeadlineDenominator));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_CONSTRAINEDTASK)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_CONSTRAINEDTASK)) return true;
    }
    return false;
  }

  static Optional<ConstrainedTask> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ConstrainedTaskViewer(vertex)) : Optional.empty();
  }

  static Optional<ConstrainedTask> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ConstrainedTaskViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static ConstrainedTask enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_CONSTRAINEDTASK);
    vertex.ports.addAll(ConstrainedTask.getRequiredPorts());
    for(String key : ConstrainedTask.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, ConstrainedTask.getRequiredProperties().get(key));
    }
    return new ConstrainedTaskViewer(vertex);
  }

  static ConstrainedTask enforce(VertexViewer viewer) {
    return ConstrainedTask.enforce(viewer.getViewedVertex());
  }
}
