package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class ConstrainedTaskViewer implements ConstrainedTask {
  public final Vertex viewedVertex;

  public ConstrainedTaskViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "ConstrainedTask".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof ConstrainedTaskViewer ? ((ConstrainedTaskViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "ConstrainedTaskViewer{" + getViewedVertex().toString() + "}";
  }
}
