package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ExtendedPrecedenceConstraint extends PrecedenceConstraint, VertexViewer {
  /**
   * getter for required property "predecessorInstance".
   * @return "predecessorInstance".
   * " property
   */
  @SuppressWarnings("unchecked")
  default List<Integer> getPredecessorInstance() {
    return getViewedVertex().getProperties().containsKey("predecessorInstance") ?
                    (List<Integer>) getViewedVertex().getProperties().get("predecessorInstance").unwrap() :
                    null;
  }

  /**
   * setter for named required property "predecessorInstance".
   * @param predecessorInstance value for required property "predecessorInstance".
   */
  default void setPredecessorInstance(List<Integer> predecessorInstance) {
    getViewedVertex().getProperties().put("predecessorInstance", VertexProperty.create(predecessorInstance));
  }

  /**
   * getter for required property "sucessorInstance".
   * @return "sucessorInstance".
   * " property
   */
  @SuppressWarnings("unchecked")
  default List<Integer> getSucessorInstance() {
    return getViewedVertex().getProperties().containsKey("sucessorInstance") ?
                    (List<Integer>) getViewedVertex().getProperties().get("sucessorInstance").unwrap() :
                    null;
  }

  /**
   * setter for named required property "sucessorInstance".
   * @param sucessorInstance value for required property "sucessorInstance".
   */
  default void setSucessorInstance(List<Integer> sucessorInstance) {
    getViewedVertex().getProperties().put("sucessorInstance", VertexProperty.create(sucessorInstance));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_EXTENDEDPRECEDENCECONSTRAINT)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_EXTENDEDPRECEDENCECONSTRAINT)) return true;
    }
    return false;
  }

  static Optional<ExtendedPrecedenceConstraint> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ExtendedPrecedenceConstraintViewer(vertex)) : Optional.empty();
  }

  static Optional<ExtendedPrecedenceConstraint> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ExtendedPrecedenceConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static ExtendedPrecedenceConstraint enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_EXTENDEDPRECEDENCECONSTRAINT);
    vertex.ports.addAll(ExtendedPrecedenceConstraint.getRequiredPorts());
    for(String key : ExtendedPrecedenceConstraint.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, ExtendedPrecedenceConstraint.getRequiredProperties().get(key));
    }
    return new ExtendedPrecedenceConstraintViewer(vertex);
  }

  static ExtendedPrecedenceConstraint enforce(VertexViewer viewer) {
    return ExtendedPrecedenceConstraint.enforce(viewer.getViewedVertex());
  }
}
