package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface PeriodicStimulus extends Stimulus, VertexViewer {
  /**
   * getter for required property "periodNumerator".
   * @return "periodNumerator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getPeriodNumerator() {
    return getViewedVertex().getProperties().containsKey("periodNumerator") ?
                    (Long) getViewedVertex().getProperties().get("periodNumerator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "periodNumerator".
   * @param periodNumerator value for required property "periodNumerator".
   */
  default void setPeriodNumerator(Long periodNumerator) {
    getViewedVertex().getProperties().put("periodNumerator", VertexProperty.create(periodNumerator));
  }

  /**
   * getter for required property "periodDenominator".
   * @return "periodDenominator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getPeriodDenominator() {
    return getViewedVertex().getProperties().containsKey("periodDenominator") ?
                    (Long) getViewedVertex().getProperties().get("periodDenominator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "periodDenominator".
   * @param periodDenominator value for required property "periodDenominator".
   */
  default void setPeriodDenominator(Long periodDenominator) {
    getViewedVertex().getProperties().put("periodDenominator", VertexProperty.create(periodDenominator));
  }

  /**
   * getter for required property "offsetNumerator".
   * @return "offsetNumerator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getOffsetNumerator() {
    return getViewedVertex().getProperties().containsKey("offsetNumerator") ?
                    (Long) getViewedVertex().getProperties().get("offsetNumerator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "offsetNumerator".
   * @param offsetNumerator value for required property "offsetNumerator".
   */
  default void setOffsetNumerator(Long offsetNumerator) {
    getViewedVertex().getProperties().put("offsetNumerator", VertexProperty.create(offsetNumerator));
  }

  /**
   * getter for required property "offsetDenominator".
   * @return "offsetDenominator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getOffsetDenominator() {
    return getViewedVertex().getProperties().containsKey("offsetDenominator") ?
                    (Long) getViewedVertex().getProperties().get("offsetDenominator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "offsetDenominator".
   * @param offsetDenominator value for required property "offsetDenominator".
   */
  default void setOffsetDenominator(Long offsetDenominator) {
    getViewedVertex().getProperties().put("offsetDenominator", VertexProperty.create(offsetDenominator));
  }

  default Set<Task> getStimulatedPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "stimulated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PERIODICSTIMULUS)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PERIODICSTIMULUS)) return true;
    }
    return false;
  }

  static Optional<PeriodicStimulus> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PeriodicStimulusViewer(vertex)) : Optional.empty();
  }

  static Optional<PeriodicStimulus> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PeriodicStimulusViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("stimulated");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static PeriodicStimulus enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_PERIODICSTIMULUS);
    vertex.ports.addAll(PeriodicStimulus.getRequiredPorts());
    for(String key : PeriodicStimulus.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, PeriodicStimulus.getRequiredProperties().get(key));
    }
    return new PeriodicStimulusViewer(vertex);
  }

  static PeriodicStimulus enforce(VertexViewer viewer) {
    return PeriodicStimulus.enforce(viewer.getViewedVertex());
  }
}
