package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class PeriodicStimulusViewer implements PeriodicStimulus {
  public final Vertex viewedVertex;

  public PeriodicStimulusViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "PeriodicStimulus".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof PeriodicStimulusViewer ? ((PeriodicStimulusViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "PeriodicStimulusViewer{" + getViewedVertex().toString() + "}";
  }
}
