package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface PeriodicTask extends Task, VertexViewer {
  default Optional<PeriodicStimulus> getPeriodicStimulusPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "periodicStimulus", VertexTrait.EXECUTION_PERIODICSTIMULUS, "incoming").map(v -> PeriodicStimulus.safeCast(v).get());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PERIODICTASK)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PERIODICTASK)) return true;
    }
    return false;
  }

  static Optional<PeriodicTask> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PeriodicTaskViewer(vertex)) : Optional.empty();
  }

  static Optional<PeriodicTask> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PeriodicTaskViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("periodicStimulus");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static PeriodicTask enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_PERIODICTASK);
    vertex.ports.addAll(PeriodicTask.getRequiredPorts());
    for(String key : PeriodicTask.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, PeriodicTask.getRequiredProperties().get(key));
    }
    return new PeriodicTaskViewer(vertex);
  }

  static PeriodicTask enforce(VertexViewer viewer) {
    return PeriodicTask.enforce(viewer.getViewedVertex());
  }
}
