package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class PeriodicTaskViewer implements PeriodicTask {
  public final Vertex viewedVertex;

  public PeriodicTaskViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "PeriodicTask".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof PeriodicTaskViewer ? ((PeriodicTaskViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "PeriodicTaskViewer{" + getViewedVertex().toString() + "}";
  }
}
