package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface PrecedenceConstraint extends RuntimeConstraint, VertexViewer {
  default Set<Task> getPredecessorPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "predecessor", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
  }

  default Set<Task> getSucessorPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "sucessor", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT)) return true;
    }
    return false;
  }

  static Optional<PrecedenceConstraint> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PrecedenceConstraintViewer(vertex)) : Optional.empty();
  }

  static Optional<PrecedenceConstraint> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PrecedenceConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("predecessor", "sucessor");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static PrecedenceConstraint enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT);
    vertex.ports.addAll(PrecedenceConstraint.getRequiredPorts());
    for(String key : PrecedenceConstraint.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, PrecedenceConstraint.getRequiredProperties().get(key));
    }
    return new PrecedenceConstraintViewer(vertex);
  }

  static PrecedenceConstraint enforce(VertexViewer viewer) {
    return PrecedenceConstraint.enforce(viewer.getViewedVertex());
  }
}
