package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class PrecedenceConstraintViewer implements PrecedenceConstraint {
  public final Vertex viewedVertex;

  public PrecedenceConstraintViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "PrecedenceConstraint".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof PrecedenceConstraintViewer ? ((PrecedenceConstraintViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "PrecedenceConstraintViewer{" + getViewedVertex().toString() + "}";
  }
}
