package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface RuntimeConstraint extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_RUNTIMECONSTRAINT)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_RUNTIMECONSTRAINT)) return true;
    }
    return false;
  }

  static Optional<RuntimeConstraint> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new RuntimeConstraintViewer(vertex)) : Optional.empty();
  }

  static Optional<RuntimeConstraint> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new RuntimeConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static RuntimeConstraint enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_RUNTIMECONSTRAINT);
    vertex.ports.addAll(RuntimeConstraint.getRequiredPorts());
    for(String key : RuntimeConstraint.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, RuntimeConstraint.getRequiredProperties().get(key));
    }
    return new RuntimeConstraintViewer(vertex);
  }

  static RuntimeConstraint enforce(VertexViewer viewer) {
    return RuntimeConstraint.enforce(viewer.getViewedVertex());
  }
}
