package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class RuntimeConstraintViewer implements RuntimeConstraint {
  public final Vertex viewedVertex;

  public RuntimeConstraintViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "RuntimeConstraint".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof RuntimeConstraintViewer ? ((RuntimeConstraintViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "RuntimeConstraintViewer{" + getViewedVertex().toString() + "}";
  }
}
