package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Stimulus extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_STIMULUS)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_STIMULUS)) return true;
    }
    return false;
  }

  static Optional<Stimulus> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new StimulusViewer(vertex)) : Optional.empty();
  }

  static Optional<Stimulus> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new StimulusViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Stimulus enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_STIMULUS);
    vertex.ports.addAll(Stimulus.getRequiredPorts());
    for(String key : Stimulus.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Stimulus.getRequiredProperties().get(key));
    }
    return new StimulusViewer(vertex);
  }

  static Stimulus enforce(VertexViewer viewer) {
    return Stimulus.enforce(viewer.getViewedVertex());
  }
}
