package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class StimulusViewer implements Stimulus {
  public final Vertex viewedVertex;

  public StimulusViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Stimulus".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof StimulusViewer ? ((StimulusViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "StimulusViewer{" + getViewedVertex().toString() + "}";
  }
}
