package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Task extends VertexViewer {
  default List<Executable> getCallSequencePort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "callSequence", VertexTrait.IMPL_EXECUTABLE, "outgoing").stream().map(v -> Executable.safeCast(v).get()).collect(Collectors.toList());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_TASK)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_TASK)) return true;
    }
    return false;
  }

  static Optional<Task> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new TaskViewer(vertex)) : Optional.empty();
  }

  static Optional<Task> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new TaskViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("callSequence");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Task enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_TASK);
    vertex.ports.addAll(Task.getRequiredPorts());
    for(String key : Task.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Task.getRequiredProperties().get(key));
    }
    return new TaskViewer(vertex);
  }

  static Task enforce(VertexViewer viewer) {
    return Task.enforce(viewer.getViewedVertex());
  }
}
