package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class TaskViewer implements Task {
  public final Vertex viewedVertex;

  public TaskViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Task".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof TaskViewer ? ((TaskViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "TaskViewer{" + getViewedVertex().toString() + "}";
  }
}
