package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Executable extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.IMPL_EXECUTABLE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.IMPL_EXECUTABLE)) return true;
    }
    return false;
  }

  static Optional<Executable> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ExecutableViewer(vertex)) : Optional.empty();
  }

  static Optional<Executable> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ExecutableViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Executable enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.IMPL_EXECUTABLE);
    vertex.ports.addAll(Executable.getRequiredPorts());
    for(String key : Executable.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Executable.getRequiredProperties().get(key));
    }
    return new ExecutableViewer(vertex);
  }

  static Executable enforce(VertexViewer viewer) {
    return Executable.enforce(viewer.getViewedVertex());
  }
}
