package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class ExecutableViewer implements Executable {
  public final Vertex viewedVertex;

  public ExecutableViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Executable".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof ExecutableViewer ? ((ExecutableViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "ExecutableViewer{" + getViewedVertex().toString() + "}";
  }
}
