package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedExecutable extends Executable, VertexViewer {
  /**
   * getter for required property "operationRequirements".
   * @return "operationRequirements".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Map<String, Long>> getOperationRequirements() {
    return getViewedVertex().getProperties().containsKey("operationRequirements") ?
                    (Map<String, Map<String, Long>>) getViewedVertex().getProperties().get("operationRequirements").unwrap() :
                    null;
  }

  /**
   * setter for named required property "operationRequirements".
   * @param operationRequirements value for required property "operationRequirements".
   */
  default void setOperationRequirements(Map<String, Map<String, Long>> operationRequirements) {
    getViewedVertex().getProperties().put("operationRequirements", VertexProperty.create(operationRequirements));
  }

  /**
   * getter for required property "sizeInBits".
   * @return "sizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getSizeInBits() {
    return getViewedVertex().getProperties().containsKey("sizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("sizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "sizeInBits".
   * @param sizeInBits value for required property "sizeInBits".
   */
  default void setSizeInBits(Long sizeInBits) {
    getViewedVertex().getProperties().put("sizeInBits", VertexProperty.create(sizeInBits));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE)) return true;
    }
    return false;
  }

  static Optional<InstrumentedExecutable> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new InstrumentedExecutableViewer(vertex)) : Optional.empty();
  }

  static Optional<InstrumentedExecutable> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new InstrumentedExecutableViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static InstrumentedExecutable enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE);
    vertex.ports.addAll(InstrumentedExecutable.getRequiredPorts());
    for(String key : InstrumentedExecutable.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, InstrumentedExecutable.getRequiredProperties().get(key));
    }
    return new InstrumentedExecutableViewer(vertex);
  }

  static InstrumentedExecutable enforce(VertexViewer viewer) {
    return InstrumentedExecutable.enforce(viewer.getViewedVertex());
  }
}
