package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class InstrumentedExecutableViewer implements InstrumentedExecutable {
  public final Vertex viewedVertex;

  public InstrumentedExecutableViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "InstrumentedExecutable".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof InstrumentedExecutableViewer ? ((InstrumentedExecutableViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "InstrumentedExecutableViewer{" + getViewedVertex().toString() + "}";
  }
}
