package forsyde.io.java.typed.viewers.moc;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface MoCElem extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_MOCELEM)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_MOCELEM)) return true;
    }
    return false;
  }

  static Optional<MoCElem> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new MoCElemViewer(vertex)) : Optional.empty();
  }

  static Optional<MoCElem> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new MoCElemViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static MoCElem enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_MOCELEM);
    vertex.ports.addAll(MoCElem.getRequiredPorts());
    for(String key : MoCElem.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, MoCElem.getRequiredProperties().get(key));
    }
    return new MoCElemViewer(vertex);
  }

  static MoCElem enforce(VertexViewer viewer) {
    return MoCElem.enforce(viewer.getViewedVertex());
  }
}
