package forsyde.io.java.typed.viewers.moc;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class MoCElemViewer implements MoCElem {
  public final Vertex viewedVertex;

  public MoCElemViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "MoCElem".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof MoCElemViewer ? ((MoCElemViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "MoCElemViewer{" + getViewedVertex().toString() + "}";
  }
}
