package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.MoCElem;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface LinguaFrancaElem extends MoCElem, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAELEM)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAELEM)) return true;
    }
    return false;
  }

  static Optional<LinguaFrancaElem> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new LinguaFrancaElemViewer(vertex)) : Optional.empty();
  }

  static Optional<LinguaFrancaElem> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new LinguaFrancaElemViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static LinguaFrancaElem enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAELEM);
    vertex.ports.addAll(LinguaFrancaElem.getRequiredPorts());
    for(String key : LinguaFrancaElem.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, LinguaFrancaElem.getRequiredProperties().get(key));
    }
    return new LinguaFrancaElemViewer(vertex);
  }

  static LinguaFrancaElem enforce(VertexViewer viewer) {
    return LinguaFrancaElem.enforce(viewer.getViewedVertex());
  }
}
