package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface LinguaFrancaReaction extends LinguaFrancaElem, VertexViewer {
  /**
   * getter for required property "sizeInBits".
   * @return "sizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getSizeInBits() {
    return getViewedVertex().getProperties().containsKey("sizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("sizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "sizeInBits".
   * @param sizeInBits value for required property "sizeInBits".
   */
  default void setSizeInBits(Long sizeInBits) {
    getViewedVertex().getProperties().put("sizeInBits", VertexProperty.create(sizeInBits));
  }

  default Optional<Executable> getImplementationPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "implementation", VertexTrait.IMPL_EXECUTABLE, "bidirectional").map(v -> Executable.safeCast(v).get());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTION)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTION)) return true;
    }
    return false;
  }

  static Optional<LinguaFrancaReaction> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new LinguaFrancaReactionViewer(vertex)) : Optional.empty();
  }

  static Optional<LinguaFrancaReaction> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new LinguaFrancaReactionViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("implementation");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static LinguaFrancaReaction enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTION);
    vertex.ports.addAll(LinguaFrancaReaction.getRequiredPorts());
    for(String key : LinguaFrancaReaction.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, LinguaFrancaReaction.getRequiredProperties().get(key));
    }
    return new LinguaFrancaReactionViewer(vertex);
  }

  static LinguaFrancaReaction enforce(VertexViewer viewer) {
    return LinguaFrancaReaction.enforce(viewer.getViewedVertex());
  }
}
