package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface LinguaFrancaReactor extends LinguaFrancaElem, VertexViewer {
  /**
   * getter for required property "stateSizesInBits".
   * @return "stateSizesInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default List<Long> getStateSizesInBits() {
    return getViewedVertex().getProperties().containsKey("stateSizesInBits") ?
                    (List<Long>) getViewedVertex().getProperties().get("stateSizesInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "stateSizesInBits".
   * @param stateSizesInBits value for required property "stateSizesInBits".
   */
  default void setStateSizesInBits(List<Long> stateSizesInBits) {
    getViewedVertex().getProperties().put("stateSizesInBits", VertexProperty.create(stateSizesInBits));
  }

  /**
   * getter for required property "stateNames".
   * @return "stateNames".
   * " property
   */
  @SuppressWarnings("unchecked")
  default List<String> getStateNames() {
    return getViewedVertex().getProperties().containsKey("stateNames") ?
                    (List<String>) getViewedVertex().getProperties().get("stateNames").unwrap() :
                    null;
  }

  /**
   * setter for named required property "stateNames".
   * @param stateNames value for required property "stateNames".
   */
  default void setStateNames(List<String> stateNames) {
    getViewedVertex().getProperties().put("stateNames", VertexProperty.create(stateNames));
  }

  default List<LinguaFrancaReactor> getChildrenReactorsPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "childrenReactors", VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR, "bidirectional").stream().map(v -> LinguaFrancaReactor.safeCast(v).get()).collect(Collectors.toList());
  }

  default List<LinguaFrancaReaction> getReactionsPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "reactions", VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTION, "bidirectional").stream().map(v -> LinguaFrancaReaction.safeCast(v).get()).collect(Collectors.toList());
  }

  default Set<LinguaFrancaTimer> getTimersPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "timers", VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCATIMER, "bidirectional").stream().map(v -> LinguaFrancaTimer.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR)) return true;
    }
    return false;
  }

  static Optional<LinguaFrancaReactor> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new LinguaFrancaReactorViewer(vertex)) : Optional.empty();
  }

  static Optional<LinguaFrancaReactor> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new LinguaFrancaReactorViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("childrenReactors", "reactions", "timers");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static LinguaFrancaReactor enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR);
    vertex.ports.addAll(LinguaFrancaReactor.getRequiredPorts());
    for(String key : LinguaFrancaReactor.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, LinguaFrancaReactor.getRequiredProperties().get(key));
    }
    return new LinguaFrancaReactorViewer(vertex);
  }

  static LinguaFrancaReactor enforce(VertexViewer viewer) {
    return LinguaFrancaReactor.enforce(viewer.getViewedVertex());
  }
}
