package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface LinguaFrancaSignal extends LinguaFrancaElem, VertexViewer {
  /**
   * getter for required property "sizeInBits".
   * @return "sizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getSizeInBits() {
    return getViewedVertex().getProperties().containsKey("sizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("sizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "sizeInBits".
   * @param sizeInBits value for required property "sizeInBits".
   */
  default void setSizeInBits(Long sizeInBits) {
    getViewedVertex().getProperties().put("sizeInBits", VertexProperty.create(sizeInBits));
  }

  /**
   * getter for required property "propagationDelayInSecsNumerator".
   * @return "propagationDelayInSecsNumerator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getPropagationDelayInSecsNumerator() {
    return getViewedVertex().getProperties().containsKey("propagationDelayInSecsNumerator") ?
                    (Long) getViewedVertex().getProperties().get("propagationDelayInSecsNumerator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "propagationDelayInSecsNumerator".
   * @param propagationDelayInSecsNumerator value for required property "propagationDelayInSecsNumerator".
   */
  default void setPropagationDelayInSecsNumerator(Long propagationDelayInSecsNumerator) {
    getViewedVertex().getProperties().put("propagationDelayInSecsNumerator", VertexProperty.create(propagationDelayInSecsNumerator));
  }

  /**
   * getter for required property "propagationDelayInSecsDenominator".
   * @return "propagationDelayInSecsDenominator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getPropagationDelayInSecsDenominator() {
    return getViewedVertex().getProperties().containsKey("propagationDelayInSecsDenominator") ?
                    (Long) getViewedVertex().getProperties().get("propagationDelayInSecsDenominator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "propagationDelayInSecsDenominator".
   * @param propagationDelayInSecsDenominator value for required property "propagationDelayInSecsDenominator".
   */
  default void setPropagationDelayInSecsDenominator(Long propagationDelayInSecsDenominator) {
    getViewedVertex().getProperties().put("propagationDelayInSecsDenominator", VertexProperty.create(propagationDelayInSecsDenominator));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL)) return true;
    }
    return false;
  }

  static Optional<LinguaFrancaSignal> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new LinguaFrancaSignalViewer(vertex)) : Optional.empty();
  }

  static Optional<LinguaFrancaSignal> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new LinguaFrancaSignalViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static LinguaFrancaSignal enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL);
    vertex.ports.addAll(LinguaFrancaSignal.getRequiredPorts());
    for(String key : LinguaFrancaSignal.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, LinguaFrancaSignal.getRequiredProperties().get(key));
    }
    return new LinguaFrancaSignalViewer(vertex);
  }

  static LinguaFrancaSignal enforce(VertexViewer viewer) {
    return LinguaFrancaSignal.enforce(viewer.getViewedVertex());
  }
}
