package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class LinguaFrancaSignalViewer implements LinguaFrancaSignal {
  public final Vertex viewedVertex;

  public LinguaFrancaSignalViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "LinguaFrancaSignal".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof LinguaFrancaSignalViewer ? ((LinguaFrancaSignalViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "LinguaFrancaSignalViewer{" + getViewedVertex().toString() + "}";
  }
}
