package forsyde.io.java.typed.viewers.moc.linguafranca;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface LinguaFrancaTimer extends LinguaFrancaElem, VertexViewer {
  /**
   * getter for required property "periodNumeratorPerSec".
   * @return "periodNumeratorPerSec".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getPeriodNumeratorPerSec() {
    return getViewedVertex().getProperties().containsKey("periodNumeratorPerSec") ?
                    (Integer) getViewedVertex().getProperties().get("periodNumeratorPerSec").unwrap() :
                    null;
  }

  /**
   * setter for named required property "periodNumeratorPerSec".
   * @param periodNumeratorPerSec value for required property "periodNumeratorPerSec".
   */
  default void setPeriodNumeratorPerSec(Integer periodNumeratorPerSec) {
    getViewedVertex().getProperties().put("periodNumeratorPerSec", VertexProperty.create(periodNumeratorPerSec));
  }

  /**
   * getter for required property "periodDenominatorPerSec".
   * @return "periodDenominatorPerSec".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getPeriodDenominatorPerSec() {
    return getViewedVertex().getProperties().containsKey("periodDenominatorPerSec") ?
                    (Integer) getViewedVertex().getProperties().get("periodDenominatorPerSec").unwrap() :
                    null;
  }

  /**
   * setter for named required property "periodDenominatorPerSec".
   * @param periodDenominatorPerSec value for required property "periodDenominatorPerSec".
   */
  default void setPeriodDenominatorPerSec(Integer periodDenominatorPerSec) {
    getViewedVertex().getProperties().put("periodDenominatorPerSec", VertexProperty.create(periodDenominatorPerSec));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCATIMER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCATIMER)) return true;
    }
    return false;
  }

  static Optional<LinguaFrancaTimer> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new LinguaFrancaTimerViewer(vertex)) : Optional.empty();
  }

  static Optional<LinguaFrancaTimer> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new LinguaFrancaTimerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static LinguaFrancaTimer enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCATIMER);
    vertex.ports.addAll(LinguaFrancaTimer.getRequiredPorts());
    for(String key : LinguaFrancaTimer.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, LinguaFrancaTimer.getRequiredProperties().get(key));
    }
    return new LinguaFrancaTimerViewer(vertex);
  }

  static LinguaFrancaTimer enforce(VertexViewer viewer) {
    return LinguaFrancaTimer.enforce(viewer.getViewedVertex());
  }
}
