package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFChannel extends SDFElem, VertexViewer {
  /**
   * getter for required property "tokenSizeInBits".
   * @return "tokenSizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getTokenSizeInBits() {
    return getViewedVertex().getProperties().containsKey("tokenSizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("tokenSizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "tokenSizeInBits".
   * @param tokenSizeInBits value for required property "tokenSizeInBits".
   */
  default void setTokenSizeInBits(Long tokenSizeInBits) {
    getViewedVertex().getProperties().put("tokenSizeInBits", VertexProperty.create(tokenSizeInBits));
  }

  default Optional<SDFElem> getProducerPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "producer", VertexTrait.MOC_SDF_SDFELEM, "incoming").map(v -> SDFElem.safeCast(v).get());
  }

  default Optional<SDFElem> getConsumerPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "consumer", VertexTrait.MOC_SDF_SDFELEM, "outgoing").map(v -> SDFElem.safeCast(v).get());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFCHANNEL)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFCHANNEL)) return true;
    }
    return false;
  }

  static Optional<SDFChannel> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new SDFChannelViewer(vertex)) : Optional.empty();
  }

  static Optional<SDFChannel> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new SDFChannelViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("producer", "consumer");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static SDFChannel enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_SDF_SDFCHANNEL);
    vertex.ports.addAll(SDFChannel.getRequiredPorts());
    for(String key : SDFChannel.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, SDFChannel.getRequiredProperties().get(key));
    }
    return new SDFChannelViewer(vertex);
  }

  static SDFChannel enforce(VertexViewer viewer) {
    return SDFChannel.enforce(viewer.getViewedVertex());
  }
}
