package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class SDFChannelViewer implements SDFChannel {
  public final Vertex viewedVertex;

  public SDFChannelViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "SDFChannel".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof SDFChannelViewer ? ((SDFChannelViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "SDFChannelViewer{" + getViewedVertex().toString() + "}";
  }
}
