package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFComb extends SDFElem, VertexViewer {
  /**
   * getter for required property "consumption".
   * @return "consumption".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Integer> getConsumption() {
    return getViewedVertex().getProperties().containsKey("consumption") ?
                    (Map<String, Integer>) getViewedVertex().getProperties().get("consumption").unwrap() :
                    null;
  }

  /**
   * setter for named required property "consumption".
   * @param consumption value for required property "consumption".
   */
  default void setConsumption(Map<String, Integer> consumption) {
    getViewedVertex().getProperties().put("consumption", VertexProperty.create(consumption));
  }

  /**
   * getter for required property "production".
   * @return "production".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Integer> getProduction() {
    return getViewedVertex().getProperties().containsKey("production") ?
                    (Map<String, Integer>) getViewedVertex().getProperties().get("production").unwrap() :
                    null;
  }

  /**
   * setter for named required property "production".
   * @param production value for required property "production".
   */
  default void setProduction(Map<String, Integer> production) {
    getViewedVertex().getProperties().put("production", VertexProperty.create(production));
  }

  default Optional<Executable> getCombFunctionPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "combFunction", VertexTrait.IMPL_EXECUTABLE, "bidirectional").map(v -> Executable.safeCast(v).get());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFCOMB)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFCOMB)) return true;
    }
    return false;
  }

  static Optional<SDFComb> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new SDFCombViewer(vertex)) : Optional.empty();
  }

  static Optional<SDFComb> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new SDFCombViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("combFunction");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static SDFComb enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_SDF_SDFCOMB);
    vertex.ports.addAll(SDFComb.getRequiredPorts());
    for(String key : SDFComb.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, SDFComb.getRequiredProperties().get(key));
    }
    return new SDFCombViewer(vertex);
  }

  static SDFComb enforce(VertexViewer viewer) {
    return SDFComb.enforce(viewer.getViewedVertex());
  }
}
