package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class SDFCombViewer implements SDFComb {
  public final Vertex viewedVertex;

  public SDFCombViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "SDFComb".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof SDFCombViewer ? ((SDFCombViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "SDFCombViewer{" + getViewedVertex().toString() + "}";
  }
}
