package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFDelay extends SDFElem, VertexViewer {
  /**
   * getter for required property "delayedTokens".
   * @return "delayedTokens".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getDelayedTokens() {
    return getViewedVertex().getProperties().containsKey("delayedTokens") ?
                    (Integer) getViewedVertex().getProperties().get("delayedTokens").unwrap() :
                    null;
  }

  /**
   * setter for named required property "delayedTokens".
   * @param delayedTokens value for required property "delayedTokens".
   */
  default void setDelayedTokens(Integer delayedTokens) {
    getViewedVertex().getProperties().put("delayedTokens", VertexProperty.create(delayedTokens));
  }

  default Optional<Executable> getDelayFunctionPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "delayFunction", VertexTrait.IMPL_EXECUTABLE, "bidirectional").map(v -> Executable.safeCast(v).get());
  }

  default Optional<SDFChannel> getNotDelayedChannelPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "notDelayedChannel", VertexTrait.MOC_SDF_SDFCHANNEL, "incoming").map(v -> SDFChannel.safeCast(v).get());
  }

  default Optional<SDFChannel> getDelayedChannelPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getNamedPort(model, getViewedVertex(), "delayedChannel", VertexTrait.MOC_SDF_SDFCHANNEL, "outgoing").map(v -> SDFChannel.safeCast(v).get());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFDELAY)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFDELAY)) return true;
    }
    return false;
  }

  static Optional<SDFDelay> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new SDFDelayViewer(vertex)) : Optional.empty();
  }

  static Optional<SDFDelay> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new SDFDelayViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("delayFunction", "notDelayedChannel", "delayedChannel");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static SDFDelay enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_SDF_SDFDELAY);
    vertex.ports.addAll(SDFDelay.getRequiredPorts());
    for(String key : SDFDelay.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, SDFDelay.getRequiredProperties().get(key));
    }
    return new SDFDelayViewer(vertex);
  }

  static SDFDelay enforce(VertexViewer viewer) {
    return SDFDelay.enforce(viewer.getViewedVertex());
  }
}
