package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class SDFDelayViewer implements SDFDelay {
  public final Vertex viewedVertex;

  public SDFDelayViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "SDFDelay".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof SDFDelayViewer ? ((SDFDelayViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "SDFDelayViewer{" + getViewedVertex().toString() + "}";
  }
}
