package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.MoCElem;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFElem extends MoCElem, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFELEM)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.MOC_SDF_SDFELEM)) return true;
    }
    return false;
  }

  static Optional<SDFElem> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new SDFElemViewer(vertex)) : Optional.empty();
  }

  static Optional<SDFElem> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new SDFElemViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static SDFElem enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.MOC_SDF_SDFELEM);
    vertex.ports.addAll(SDFElem.getRequiredPorts());
    for(String key : SDFElem.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, SDFElem.getRequiredProperties().get(key));
    }
    return new SDFElemViewer(vertex);
  }

  static SDFElem enforce(VertexViewer viewer) {
    return SDFElem.enforce(viewer.getViewedVertex());
  }
}
