package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class SDFElemViewer implements SDFElem {
  public final Vertex viewedVertex;

  public SDFElemViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "SDFElem".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof SDFElemViewer ? ((SDFElemViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "SDFElemViewer{" + getViewedVertex().toString() + "}";
  }
}
