package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface AbstractStructure extends PlatformElem, VertexViewer {
  default Set<PlatformElem> getChildrenPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "children", VertexTrait.PLATFORM_PLATFORMELEM, "bidirectional").stream().map(v -> PlatformElem.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_ABSTRACTSTRUCTURE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_ABSTRACTSTRUCTURE)) return true;
    }
    return false;
  }

  static Optional<AbstractStructure> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new AbstractStructureViewer(vertex)) : Optional.empty();
  }

  static Optional<AbstractStructure> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new AbstractStructureViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("children");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static AbstractStructure enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_ABSTRACTSTRUCTURE);
    vertex.ports.addAll(AbstractStructure.getRequiredPorts());
    for(String key : AbstractStructure.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, AbstractStructure.getRequiredProperties().get(key));
    }
    return new AbstractStructureViewer(vertex);
  }

  static AbstractStructure enforce(VertexViewer viewer) {
    return AbstractStructure.enforce(viewer.getViewedVertex());
  }
}
