package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class AbstractStructureViewer implements AbstractStructure {
  public final Vertex viewedVertex;

  public AbstractStructureViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "AbstractStructure".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof AbstractStructureViewer ? ((AbstractStructureViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "AbstractStructureViewer{" + getViewedVertex().toString() + "}";
  }
}
