package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface DigitalModule extends PlatformElem, VertexViewer {
  /**
   * getter for required property "operatingFrequencyInHertz".
   * @return "operatingFrequencyInHertz".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getOperatingFrequencyInHertz() {
    return getViewedVertex().getProperties().containsKey("operatingFrequencyInHertz") ?
                    (Long) getViewedVertex().getProperties().get("operatingFrequencyInHertz").unwrap() :
                    null;
  }

  /**
   * setter for named required property "operatingFrequencyInHertz".
   * @param operatingFrequencyInHertz value for required property "operatingFrequencyInHertz".
   */
  default void setOperatingFrequencyInHertz(Long operatingFrequencyInHertz) {
    getViewedVertex().getProperties().put("operatingFrequencyInHertz", VertexProperty.create(operatingFrequencyInHertz));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_DIGITALMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_DIGITALMODULE)) return true;
    }
    return false;
  }

  static Optional<DigitalModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new DigitalModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<DigitalModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new DigitalModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static DigitalModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_DIGITALMODULE);
    vertex.ports.addAll(DigitalModule.getRequiredPorts());
    for(String key : DigitalModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, DigitalModule.getRequiredProperties().get(key));
    }
    return new DigitalModuleViewer(vertex);
  }

  static DigitalModule enforce(VertexViewer viewer) {
    return DigitalModule.enforce(viewer.getViewedVertex());
  }
}
