package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class DigitalModuleViewer implements DigitalModule {
  public final Vertex viewedVertex;

  public DigitalModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "DigitalModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof DigitalModuleViewer ? ((DigitalModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "DigitalModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
