package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class GenericCacheModuleViewer implements GenericCacheModule {
  public final Vertex viewedVertex;

  public GenericCacheModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "GenericCacheModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof GenericCacheModuleViewer ? ((GenericCacheModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "GenericCacheModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
