package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericCommunicationModule extends DigitalModule, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Optional<GenericCommunicationModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new GenericCommunicationModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<GenericCommunicationModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new GenericCommunicationModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static GenericCommunicationModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE);
    vertex.ports.addAll(GenericCommunicationModule.getRequiredPorts());
    for(String key : GenericCommunicationModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, GenericCommunicationModule.getRequiredProperties().get(key));
    }
    return new GenericCommunicationModuleViewer(vertex);
  }

  static GenericCommunicationModule enforce(VertexViewer viewer) {
    return GenericCommunicationModule.enforce(viewer.getViewedVertex());
  }
}
