package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class GenericCommunicationModuleViewer implements GenericCommunicationModule {
  public final Vertex viewedVertex;

  public GenericCommunicationModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "GenericCommunicationModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof GenericCommunicationModuleViewer ? ((GenericCommunicationModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "GenericCommunicationModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
