package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericMemoryModule extends DigitalModule, VertexViewer {
  /**
   * getter for required property "spaceInBits".
   * @return "spaceInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getSpaceInBits() {
    return getViewedVertex().getProperties().containsKey("spaceInBits") ?
                    (Long) getViewedVertex().getProperties().get("spaceInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "spaceInBits".
   * @param spaceInBits value for required property "spaceInBits".
   */
  default void setSpaceInBits(Long spaceInBits) {
    getViewedVertex().getProperties().put("spaceInBits", VertexProperty.create(spaceInBits));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICMEMORYMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICMEMORYMODULE)) return true;
    }
    return false;
  }

  static Optional<GenericMemoryModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new GenericMemoryModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<GenericMemoryModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new GenericMemoryModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static GenericMemoryModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_GENERICMEMORYMODULE);
    vertex.ports.addAll(GenericMemoryModule.getRequiredPorts());
    for(String key : GenericMemoryModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, GenericMemoryModule.getRequiredProperties().get(key));
    }
    return new GenericMemoryModuleViewer(vertex);
  }

  static GenericMemoryModule enforce(VertexViewer viewer) {
    return GenericMemoryModule.enforce(viewer.getViewedVertex());
  }
}
