package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class GenericMemoryModuleViewer implements GenericMemoryModule {
  public final Vertex viewedVertex;

  public GenericMemoryModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "GenericMemoryModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof GenericMemoryModuleViewer ? ((GenericMemoryModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "GenericMemoryModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
