package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericProcessingModule extends DigitalModule, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE)) return true;
    }
    return false;
  }

  static Optional<GenericProcessingModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new GenericProcessingModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<GenericProcessingModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new GenericProcessingModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static GenericProcessingModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE);
    vertex.ports.addAll(GenericProcessingModule.getRequiredPorts());
    for(String key : GenericProcessingModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, GenericProcessingModule.getRequiredProperties().get(key));
    }
    return new GenericProcessingModuleViewer(vertex);
  }

  static GenericProcessingModule enforce(VertexViewer viewer) {
    return GenericProcessingModule.enforce(viewer.getViewedVertex());
  }
}
