package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class GenericProcessingModuleViewer implements GenericProcessingModule {
  public final Vertex viewedVertex;

  public GenericProcessingModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "GenericProcessingModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof GenericProcessingModuleViewer ? ((GenericProcessingModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "GenericProcessingModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
