package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedCommunicationModule extends GenericCommunicationModule, VertexViewer {
  /**
   * getter for required property "flitSizeInBits".
   * @return "flitSizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getFlitSizeInBits() {
    return getViewedVertex().getProperties().containsKey("flitSizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("flitSizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "flitSizeInBits".
   * @param flitSizeInBits value for required property "flitSizeInBits".
   */
  default void setFlitSizeInBits(Long flitSizeInBits) {
    getViewedVertex().getProperties().put("flitSizeInBits", VertexProperty.create(flitSizeInBits));
  }

  /**
   * getter for required property "maxCyclesPerFlit".
   * @return "maxCyclesPerFlit".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getMaxCyclesPerFlit() {
    return getViewedVertex().getProperties().containsKey("maxCyclesPerFlit") ?
                    (Integer) getViewedVertex().getProperties().get("maxCyclesPerFlit").unwrap() :
                    null;
  }

  /**
   * setter for named required property "maxCyclesPerFlit".
   * @param maxCyclesPerFlit value for required property "maxCyclesPerFlit".
   */
  default void setMaxCyclesPerFlit(Integer maxCyclesPerFlit) {
    getViewedVertex().getProperties().put("maxCyclesPerFlit", VertexProperty.create(maxCyclesPerFlit));
  }

  /**
   * getter for required property "maxConcurrentFlits".
   * @return "maxConcurrentFlits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getMaxConcurrentFlits() {
    return getViewedVertex().getProperties().containsKey("maxConcurrentFlits") ?
                    (Integer) getViewedVertex().getProperties().get("maxConcurrentFlits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "maxConcurrentFlits".
   * @param maxConcurrentFlits value for required property "maxConcurrentFlits".
   */
  default void setMaxConcurrentFlits(Integer maxConcurrentFlits) {
    getViewedVertex().getProperties().put("maxConcurrentFlits", VertexProperty.create(maxConcurrentFlits));
  }

  /**
   * getter for required property "initialLatency".
   * @return "initialLatency".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getInitialLatency() {
    return getViewedVertex().getProperties().containsKey("initialLatency") ?
                    (Long) getViewedVertex().getProperties().get("initialLatency").unwrap() :
                    null;
  }

  /**
   * setter for named required property "initialLatency".
   * @param initialLatency value for required property "initialLatency".
   */
  default void setInitialLatency(Long initialLatency) {
    getViewedVertex().getProperties().put("initialLatency", VertexProperty.create(initialLatency));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Optional<InstrumentedCommunicationModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new InstrumentedCommunicationModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<InstrumentedCommunicationModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new InstrumentedCommunicationModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static InstrumentedCommunicationModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE);
    vertex.ports.addAll(InstrumentedCommunicationModule.getRequiredPorts());
    for(String key : InstrumentedCommunicationModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, InstrumentedCommunicationModule.getRequiredProperties().get(key));
    }
    return new InstrumentedCommunicationModuleViewer(vertex);
  }

  static InstrumentedCommunicationModule enforce(VertexViewer viewer) {
    return InstrumentedCommunicationModule.enforce(viewer.getViewedVertex());
  }
}
