package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedProcessingModule extends GenericProcessingModule, VertexViewer {
  /**
   * getter for required property "modalInstructionsPerCycle".
   * @return "modalInstructionsPerCycle".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Map<String, Double>> getModalInstructionsPerCycle() {
    return getViewedVertex().getProperties().containsKey("modalInstructionsPerCycle") ?
                    (Map<String, Map<String, Double>>) getViewedVertex().getProperties().get("modalInstructionsPerCycle").unwrap() :
                    null;
  }

  /**
   * setter for named required property "modalInstructionsPerCycle".
   * @param modalInstructionsPerCycle value for required property "modalInstructionsPerCycle".
   */
  default void setModalInstructionsPerCycle(
      Map<String, Map<String, Double>> modalInstructionsPerCycle) {
    getViewedVertex().getProperties().put("modalInstructionsPerCycle", VertexProperty.create(modalInstructionsPerCycle));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE)) return true;
    }
    return false;
  }

  static Optional<InstrumentedProcessingModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new InstrumentedProcessingModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<InstrumentedProcessingModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new InstrumentedProcessingModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static InstrumentedProcessingModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE);
    vertex.ports.addAll(InstrumentedProcessingModule.getRequiredPorts());
    for(String key : InstrumentedProcessingModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, InstrumentedProcessingModule.getRequiredProperties().get(key));
    }
    return new InstrumentedProcessingModuleViewer(vertex);
  }

  static InstrumentedProcessingModule enforce(VertexViewer viewer) {
    return InstrumentedProcessingModule.enforce(viewer.getViewedVertex());
  }
}
