package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface PlatformElem extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_PLATFORMELEM)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_PLATFORMELEM)) return true;
    }
    return false;
  }

  static Optional<PlatformElem> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PlatformElemViewer(vertex)) : Optional.empty();
  }

  static Optional<PlatformElem> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PlatformElemViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static PlatformElem enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_PLATFORMELEM);
    vertex.ports.addAll(PlatformElem.getRequiredPorts());
    for(String key : PlatformElem.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, PlatformElem.getRequiredProperties().get(key));
    }
    return new PlatformElemViewer(vertex);
  }

  static PlatformElem enforce(VertexViewer viewer) {
    return PlatformElem.enforce(viewer.getViewedVertex());
  }
}
